/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/
#ifndef _mx__wire_h
#define _mx__wire_h

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mcp_events.h"

union mx__lib2lib {
  uint8_t type;
  /* for pseudo messages (cts/rndv) don't put anything before the evt
     so early processing works */
  struct {
    uint8_t type;
    uint8_t pad;
    uint16_t dummy;
  } connect;
  struct {
    uint8_t type;
    uint8_t pad;
    uint16_t lib_seqnum;
    uint32_t session_id;
    uint32_t acknum;
    uint16_t send_seq;
    uint8_t requeued;
    uint8_t pad1;
  } ack;
  struct {
    uint8_t type;
    uint8_t pad[3];
    mcp_uevt_msg_t evt;
    uint8_t data[8];
  } rndv;
  struct {
    uint8_t type;
    uint8_t pad[3];
    mcp_uevt_msg_t evt;
    uint32_t xfer_length;
    uint32_t send_rdma;
    uint8_t recv_rdma;
  } cts;
};

enum {
  MX__LIB2LIB_RNDV = 0x54,
  MX__LIB2LIB_ACK,
  MX__LIB2LIB_CTS,
  MX__LIB2LIB_NOTIFY,
};

#define MX__LIB2LIB(evt_req) ((union mx__lib2lib*)((evt_req)->data))

struct mx__connect_data {
  uint32_t dest_session_n;
  uint32_t app_key_n;
  uint16_t  seqnum_start_n;
  uint8_t is_reply;
  uint8_t connect_seqnum_n;
  uint8_t status_code;
};

#define MX__CONNECT_DATA(evt_req) ((struct mx__connect_data*)((evt_req)->data))

#endif /* mx__wire.h */
